#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct Poncho {
    int index;
    long long weight;
    long long value;
};

int main() {
    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;

    vector<Poncho> ponchos(N);
    for(int i = 0; i < N; i++) {
        cin >> ponchos[i].weight >> ponchos[i].value;
        ponchos[i].index = i + 1; // ??????? ?? ??????
    }

    // ???????? ?? r = value/weight, ???? ????
    sort(ponchos.begin(), ponchos.end(), [](const Poncho &a, const Poncho &b) {
        return (double)a.value / a.weight > (double)b.value / b.weight;
    });

    long long totalWeight = 0;
    vector<int> chosen;
    for(auto &p : ponchos) {
        if(totalWeight + p.weight <= W) {
            totalWeight += p.weight;
            chosen.push_back(p.index);
        }
    }

    cout << chosen.size() << "\n";
    for(int i = 0; i < chosen.size(); i++) {
        cout << chosen[i] << (i+1==chosen.size() ? "\n" : " ");
    }

    return 0;
}